char cmd[8];
int cmdi=0;

boolean takeContinuous = false;
boolean trigger = false;

int sampleSize = 100;

// defines for setting and clearing register bits
#ifndef cbi
#define cbi(sfr, bit) (_SFR_BYTE(sfr) &= ~_BV(bit))
#endif
#ifndef sbi
#define sbi(sfr, bit) (_SFR_BYTE(sfr) |= _BV(bit))
#endif

boolean cmdRx = false;  

boolean readA[6] = {true,false,false,false,false,false};

void setup()
{ 
   Serial.begin(115200);
   setADCsampleRate(1,1,1); //128
}

   double stdev(int inPin,int sSize)
   {
       double Sum = 0.0;
       double Sum_sqr = 0.0;
       double standardDeviation=0.0;
       double val;
       
          for(int i=0; i<sSize; i++)
          { 
             val = analogRead(inPin)*0.001;
             Sum = Sum + val;
             Sum_sqr = Sum_sqr + (val*val);
          }

       double mean = Sum/sSize;
       
       standardDeviation = sqrt((Sum_sqr - Sum*mean)/sSize)*1000;
       
       return standardDeviation;
   }


void loop()
{

   commandCheck();
  
   if (cmdRx==true)
   {
     
      //Take sample at ADC prescale 128 - about 10kHz
      if (same(cmd,"S128")==true)
      {
         setADCsampleRate(1,1,1); //128
         takeSample();
      }
      
      //Take sample at ADC prescale 64 - about 18kHz
      if (same(cmd,"S64")==true)
      {
         setADCsampleRate(1,1,0); //64
         takeSample();
      }
      
      //Take sample at ADC prescale 32 - about 35kHz
      if (same(cmd,"S32")==true)
      {
         setADCsampleRate(1,0,1); //32
         takeSample();
      }
      
      //Take sample at ADC prescale 16 - about 60kHz
      if (same(cmd,"S16")==true)
      {
         setADCsampleRate(1,0,0); //16
         takeSample();
      }
      
      if (same(cmd,"CSTART")==true) {Serial.println("Starting continuous logging"); takeContinuous = true;}
      if (same(cmd,"CSTOP")==true)  {Serial.println("Continuous logging stopped"); takeContinuous = false;}
      
      if (same(cmd,"A0ON")==true) readA[0]=true;
      if (same(cmd,"A1ON")==true) readA[1]=true;
      if (same(cmd,"A2ON")==true) readA[2]=true;
      if (same(cmd,"A3ON")==true) readA[3]=true;
      if (same(cmd,"A4ON")==true) readA[4]=true;
      if (same(cmd,"A5ON")==true) readA[5]=true;
      
      if (same(cmd,"A0OFF")==true) readA[0]=false;
      if (same(cmd,"A1OFF")==true) readA[1]=false;
      if (same(cmd,"A2OFF")==true) readA[2]=false;
      if (same(cmd,"A3OFF")==true) readA[3]=false;
      if (same(cmd,"A4OFF")==true) readA[4]=false;
      if (same(cmd,"A5OFF")==true) readA[5]=false;
      
      if (same(cmd,"STDEV")==true)
      {
      Serial.print("> stdev:");  
      Serial.println(stdev(0,1000)); 
      }
      
   cmdRx = false;
   }
   
   
   if (takeContinuous == true)
   {
      for (int i=0; i<6; i++)
      {
         if (readA[i]==true) { Serial.print(analogRead(i)); Serial.print(' '); }
      }
      delay(500);
      Serial.println();
   }
   
}
